local assets=
{ 
    Asset("ANIM", "anim/wand_il86.zip"),
	Asset("ANIM", "anim/swap_wand_il86.zip"),
    Asset("ATLAS", "images/inventoryimages/wand_il86.xml"),
	Asset("IMAGE", "images/inventoryimages/wand_il86.tex"),
}

local dam = 59

local function onattack_il86(inst, owner, target)
    inst.SoundEmitter:PlaySound("shots/gunshot/il86shot")	
	owner.components.inventory:ConsumeByName("nato556", 1)	
end

local function OnEquip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_object", "swap_wand_il86", "wand")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
end

local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
end



local function fn(colour)

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter() 
    ---- 
    MakeInventoryPhysics(inst)
    
	
    anim:SetBank("wand")
    anim:SetBuild("wand_il86")
    anim:PlayAnimation("idle")

	
	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(dam)
    inst.components.weapon:SetRange(16)
    inst.components.weapon:SetOnAttack(onattack_il86)
    inst.components.weapon:SetProjectile("nato556")
		
	inst:AddComponent("inspectable")
		
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "wand_il86"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wand_il86.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
	inst.HasAmmo = function(inst, owner)
		if (owner and owner.components.inventory and owner.components.inventory:Has("nato556", 1)) or (owner:HasTag("ai")) then
			return true
		end
		return false
	end
	
    return inst
end

return  Prefab("common/inventory/wand_il86", fn, assets)